//Libraries
#include <DHT.h>
#include <Adafruit_Sensor.h>
#include <Servo.h>
#include <ESP8266WiFi.h>
#include <ThingSpeak.h>

//PIN defenition
//Sensor out not being used!
#define DHTPIN_in D8  //Sensor_in Pin
#define SERVO D7 //Servo Pin
#define HEAT D9 //Heater Pin
#define FAN2 D1 //Fan 2 Pin
#define FAN1 D2 //Fan 1 Pin

/* NOTE:
 *  Ideal conditions to grow mushroom:
 *  Temperature 18 °C - 22 °C
 *  Humidity 40 % - 60 %
*/

//CONST
#define DHTTYPE DHT22   // DHT 22  (AM2302)
#define TEMPMIN_C 21 //Minimum temperature that is worth using the fans
#define TEMPMAX_C 25 //Maximum temperature that is worth using the fans
#define TEMPMIN_H 15 //Minimum temperature that is worth using the heater
#define TEMPMAX_H 19 //Maximum temperature that is worth using the heater
#define HUM_MIN 60 //Minimum humidity that is worth using the humidifier (no actuar to reduce humidity is being used)

//Objects
DHT sensor_in(DHTPIN_in, DHTTYPE); // Initialize DHT sensor
//Sensor out not being used! 
Servo myservo;  // Create a servo object to control the servo

//Variables
float hum_in;  //Stores humidity value (sensor in)
float temp_in; //Stores temperature value (sensor in)

float FanVal1; //Output value Fan 1 
float FanVal2; //Output value Fan 2
float HeatVal; //Output value Heater


unsigned long previousMillis = 0; //Will store last time was updated
const long _1min = 60000; // 1 m intervals
char cont_3min=0; // Counts time till 3 m
char cont_10min=0; // Counts time till 10 m


//To connect with thingspeak
String apiKey = "R3FHLI5AFZGP64GW"; // Enter your API key from ThingSpeak ˇ API key from our project: "R3FHLI5AFZGP64GW"
const char* ssid = "RedeCasa"; // Give your wifi network name
const char* password = "914800180"; // Give your wifi network password
const char* server = "api.thingspeak.com";
WiFiClient client; //create a client object

//Functions declaration
void heating ();
void cooling ();
void hum_ing ();
void make_it_speak();
void read_temp_hum();

//Start
void setup(){
  
  Serial.begin(115200);

  //Define pins as inputs or outputs
  pinMode(DHTPIN_in, INPUT);
  pinMode(HEAT,OUTPUT);
  pinMode(FAN1,OUTPUT);
  pinMode(FAN2,OUTPUT);
  
  delay(10);
  sensor_in.begin();
  delay(10);
  myservo.attach(SERVO);
  
  Serial.print("Connecting to ");
  Serial.println(ssid);

  WiFi.begin(ssid, password);
 
  while (WiFi.status() != WL_CONNECTED){
    delay(500);
    Serial.print(".");
  }//wait till the connection is estabilished
  Serial.println("");
  Serial.println("WiFi connected");

}


void loop(){  
  unsigned long currentMillis = millis(); //Start counting time in milliseconds since the program started

  //Read sensor values
  read_temp_hum();
  
  delay(2000);//Wait 2 s

  //Verify if the values read are valid
  if( isnan(hum_in) || isnan(temp_in) ) {
    Serial.println ("Problem Sensor In");
    return;
      
  } else { //If the values read are valid, print them in the serial monitor
              Serial.println(" "); 
      Serial.print("Temperature inside: ");
      Serial.print(temp_in);     
      Serial.print("°C. Humidity inside: ");
      Serial.print(hum_in); 
      Serial.println(" %");
              Serial.println(" ");
    }

  //All the values from here forward are valid
  //Verify if the temperature is in the right range
  if((temp_in>TEMPMAX_H) && (temp_in < TEMPMIN_C)){  
    //It doesn't need to actuate
    //Turn actuators off
    digitalWrite(HEAT,LOW);
    digitalWrite(FAN1,LOW);
    digitalWrite(FAN2,LOW);
    if(hum_in < HUM_MIN) hum_ing;
    return;
  }


 //All the values from here forward are not in the right range
  
  //Power resistors to heat
  if(temp_in < TEMPMAX_H){
    heating();
  } 
    //Fans to cool
    else if (temp_in > TEMPMIN_C) cooling();
    
  if (currentMillis - previousMillis >= _1min) { //Enters this condition every 1 m
      previousMillis = currentMillis; 
      
      cont_3min++;
      if(cont_3min==1){//Only sprinkles every 3 m (if necessary) (goes every minute just for testing)
          cont_3min=0;
                
          //Sprinkler to increase humidty
          if(hum_in < HUM_MIN) hum_ing (); 
       }

       cont_10min++;
       if(cont_10min==1){//Only send data every 10 m (goes every minute just for testing)
          cont_10min=0;
          //Send data to ThingSpeak
          make_it_speak();
       }    
  }
  
}


void  read_temp_hum(){ 
    //Read sensors values and store it in variables hum and temp
    hum_in = sensor_in.readHumidity(); delay(10);
    temp_in = sensor_in.readTemperature(); delay(10);

    hum_in += 30; //calibration
    temp_in -= 3.3; //calibration
}


void heating (){
  //Handle extreme cases
  if(temp_in < TEMPMIN_H){ //Read sensor value and set lower limit cap
    digitalWrite(HEAT, LOW); //Turn off heater
    digitalWrite(HEAT, LOW); //Turn off heater
    Serial.println("Pretty cold place, change it");
    //Send message to change places to App
    return; 
  } 
  
  //Activate actuators
  digitalWrite(HEAT, HIGH); //Activate heater
  analogWrite(FAN1, 510); //Activate fans slightly just to spread the heat

}

void cooling (){
  //Handle extreme case
  if(temp_in > TEMPMAX_C) { //Not worth using the fans
    digitalWrite(FAN1, LOW); //Turn off fan1
    digitalWrite(FAN2, LOW); //Turn off fan2
    delay(5000);
    Serial.println("Pretty hot place, change it");
    //Send message to change places ASAP to App
    return;              
  } 
  
  //Activate actuators, (fans aren't powerful enough so is not worth using pwm to regulate temperature)   
  digitalWrite(FAN1,HIGH);
  digitalWrite(FAN2,HIGH);
}

void hum_ing (){
  //Sprinkle two times
  int pos;
  char t=0;
  
  do{
    
    for (pos = -180; pos <= 180; pos += 1) { // goes from 0 degrees to 180 degrees
      //In steps of 1 degree
      myservo.write(pos);              // tell servo to go to position in variable 'pos'
      delay(5);                       // waits 10ms for the servo to reach the position
    }
    for (pos = 180; pos >= -180; pos -= 1) { // goes from 180 degrees to 0 degrees
      //In steps of 1 degree
      myservo.write(pos);              // tell servo to go to position in variable 'pos'
      delay(5);                       // waits 10ms for the servo to reach the position
    }
    t++;
    delay(500);
    
  } while (t!=2);
  
}


void  make_it_speak(){ //Updated every 10 m
  
  if (client.connect(server,80)){   //"184.106.153.149" or api.thingspeak.com 
     //Send temperature and humidity values to ThingSpeak
     String postStr = apiKey;
     postStr +="&field1=";
     postStr += String(temp_in);
     postStr +="&field2=";
     postStr += String(hum_in); 
     postStr += "\r\n\r\n";

     client.print("POST /update HTTP/1.1\n");
     client.print("Host: api.thingspeak.com\n");
     client.print("Connection: close\n");
     client.print("X-THINGSPEAKAPIKEY: "+apiKey+"\n");
     client.print("Content-Type: application/x-www-form-urlencoded\n");
     client.print("Content-Length: ");
     client.print(postStr.length());
     client.print("\n\n");
     client.print(postStr);

     Serial.print("Temperature (IN): ");
     Serial.print(temp_in);
     Serial.print(" ºC, Humidity (IN): ");
     Serial.print(hum_in);
    Serial.println(" %. Send to Thingspeak.");
     
   }
    client.stop();
  
  //The data can also be visualized in the App "ThingView" (free for download in AppStore or PlayStore)
}
